/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally;

import java.util.Calendar;
import java.util.List;
import java.util.Map;

import com.adobe.cq.social.tally.client.api.PollResponse;

/**
 * An implementation of tally that manages and keeps track of polls.
 */
public interface Poll extends Tally<PollResponse> {
    public static final String RESOURCE_TYPE = "social/tally/components/poll";
    public static final String DEFAULT_TITLE = "Poll";

    /**
     * @return the title of the poll.
     */
    public String getTitle();

    /**
     * @return the list of allowed responses as specified by the author of the poll.
     */
    public List<PollResponse> getAllowedResponses();

    /**
     * @return true if a user can select multiple responses to the poll, false otherwise.
     */
    public boolean isMultipleChoice();

    /**
     * @return true if a user is allowed to enter 'other' responses other than the allowed responses, false otherwise.
     */
    public boolean isOtherAllowed();

    /**
     * @return the description of the poll.
     */
    public String getDescription();

    /**
     * @return true if the poll is currently closed, false otherwise.
     */
    public boolean isClosed();

    /**
     * @return the date on which this poll closes as specified by the author of the poll. Returns null if no close
     *         date is specified.
     */
    public Calendar getCloseDate();

    /**
     * @return the date on which this poll was created.
     */
    public Calendar getCreateDate();

    /**
     * @return the URL to which poll responses should be posted to.
     */
    public String getPollURL();

    /**
     * @param response the string value for which the number of votes is requested for.
     * @return the number of votes that was received by the response.
     */
    public Long getPollResultForResponse(final String response);

    /**
     * @return a map of all PollResponses and the number of votes for each.
     */
    public Map<PollResponse, Long> getPollResults();

    /**
     * @return an identifier for this poll.
     */
    public String getId();
}
