/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally;

import com.adobe.cq.social.tally.client.api.TallyException;

/**
 * <code>TallyBadRequestException</code> is a specific exception for all exception in the Tally API that denote a bad
 * user request.
 */
public class TallyBadRequestException extends TallyException {

    /** A serialVersionUID for this class. */
    private static final long serialVersionUID = 1L;

    /**
     * Creates a TallyBadRequestException.
     * @param message A message that is to be goes with the exception
     */
    public TallyBadRequestException(String message) {
        super(message);
    }

    /**
     * Creates a TallyBadRequestException.
     * @param message A message that goes with the exception
     * @param cause The underlying cause for the exception
     */
    public TallyBadRequestException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a TallyBadRequestException.
     * @param cause The underlying cause for the exception
     */
    public TallyBadRequestException(final Throwable cause) {
        super(cause);
    }
}
