/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally;

/**
 * Holds string constants that are used across the Tally API.
 */
public class TallyConstants {
    private TallyConstants() {
    }

    /**
     * Name of the JCR property that stores the tally name.
     */
    public static final String NAME_PROPERTY = "name";
    /**
     * Name of the JCR property that stores the count of each response.
     */
    public static final String COUNT_PROPERTY = "count";
    /**
     * Name of the JCR property that stores the response value for each response.
     */
    public static final String RESPONSE_PROPERTY = "response";
    /**
     * Name of the JCR property that stores the timestamp value for each response.
     */
    public static final String TIMESTAMP_PROPERTY = "timestamp";
    /**
     * The path to the node where tally responses are stored relative to the tally resource.
     */
    public static final String RESPONSES_PATH = "tallyresponses";
    /**
     * The path to the node where tally counts are stored relative to the tally resource.
     */
    public static final String SUMMARY_PATH = "tallycount";
    /**
     * The response value used to indicate that a user has unset his earlier response to the tally.
     */
    public static final String UNSET_RESPONSE_VALUE = "#neutral#";
    /**
     * The resource type of a tally response resource
     */
    public static final String RESPONSE_RESOURCE_TYPE = "social/tally/components/response";
    /**
     * The resource type of all tally resources
     */
    public static final String TALLY_SUPER_RESOURCE_TYPE = "social/tally/components/tally";
    /**
     * Name of the JCR property that stores the user identifier for each response.
     */
    public static final String USER_PROPERTY = "userIdentifier";
    /**
     * The default response URL that handles all tally user responses.
     */
    public static final String DEFAULT_RESPONSE_URL_SELECTOR = ".social.settallyresponse.html";

    /**
     * The component property name for use referrer header for the @link getFriendlyUrl() value.
     */
    public static final String PROP_USE_REFERRER_URL = "useReferrer";
}
