/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally;

import com.adobe.cq.social.tally.client.api.Vote;
import com.adobe.cq.social.tally.client.api.VotingSocialComponent;
import com.adobe.cq.social.tally.client.endpoints.TallyOperationsService;

/**
 * A tally that keeps track of Votes.
 * @deprecated @since AEM 6.0. Use {@link TallyOperationsService} and {@link VotingSocialComponent} instead.
 */
@Deprecated
public interface Voting extends Tally<Vote> {
    public static final String POSTIVE_LABEL = "positiveText";
    public static final String DEFAULT_POSITIVE_LABEL = "Helpful";
    public static final String NEGATIVE_LABEL = "negativeText";
    public static final String DEFAULT_NEGATIVE_LABEL = "Unhelpful";
    public static final String VOTING_RESOURCE_TYPE = "social/tally/components/voting";
    public static final String USER_ID = "userIdentifier";

    /**
     * Gets the number of positive user responses.
     * @return the number of positive votes
     */
    public long getPositiveCount();

    /**
     * Gets the number of negative user responses.
     * @return the number of negative votes
     */
    public long getNegativeCount();

    /**
     * @return the URL to post the user responses to
     */
    public String getVoteURL();

    /**
     * @return the label for the positive response
     */
    public String getPositiveLabel();

    /**
     * @return the label for the negative response
     */
    public String getNegativeLabel();
}
