/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.tally.RatingComponent;

public abstract class AbstractRating extends AbstractTally implements RatingSocialComponent {
    private RatingComponent rating;

    private String currentUser;
    private List<String[]> ratingResults;
    protected String[] allowedResponses = {"5.0", "4.0", "3.0", "2.0", "1.0"};

    public AbstractRating(final Resource resource) {
        super(resource, null);
        initComponent();
    }

    public AbstractRating(final Resource resource, final ClientUtilities clientUtils) {
        super(resource, clientUtils);
        initComponent();
    }

    private void initComponent() {
        this.rating = this.getResource().adaptTo(RatingComponent.class);
        this.currentUser = this.getResource().getResourceResolver().getUserID();
        this.tally = this.rating;
    }

    @Override
    public String getName() {
        return this.rating.getName();
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return this.rating.getTotalNumberOfResponses();
    }

    @Override
    public ResponseValue getCurrentUserResponse() throws TallyException {
        try {
            final Response<?> resp = this.rating.getUserResponse(this.currentUser);
            if (resp == null) {
                return null;
            }
            return resp.getResponseValue();
        } catch (final RepositoryException e) {
            return null;
        }
    }

    @Override
    public Map<String, Long> getResponseTallies() {
        final Map<String, Long> local = new HashMap<String, Long>();
        final Map<com.adobe.cq.social.tally.client.api.Rating, Long> responses = this.rating.getResponseTallies();
        for (final Entry<com.adobe.cq.social.tally.client.api.Rating, Long> entry : responses.entrySet()) {
            local.put(entry.getKey().getResponseValue(), entry.getValue());
        }
        return local;
    }

    public void addResponse(final String value) {
        try {
            this.rating.setUserResponse(this.currentUser, value);
        } catch (final TallyException e) {
        } catch (final RepositoryException e) {
        }
    }

    public void removeCurrentUserResponse() {
        try {
            this.rating.unsetUserResponse(this.currentUser);
        } catch (final TallyException e) {
        } catch (final RepositoryException e) {
        }
    }

    /*
     * (non-Javadoc)
     * @see com.adobe.cq.social.tally.http.impl.Rating#getAverageRating()
     */
    @Override
    public Float getAverageRating() {
        return this.rating.getAverageRating();
    }

    @Override
    public String getFormattedAverageRating() {
        return String.format("%.2f", this.rating.getAverageRating());
    }

    @Override
    public List<String[]> getRatingResults() {
        if (null == this.ratingResults) {
            this.buildRatingResults();
        }
        return this.ratingResults;
    }

    private void buildRatingResults() {
        final Map<String, Long> responseTallies = this.getResponseTallies();
        this.ratingResults = new ArrayList<String[]>(allowedResponses.length);
        for (final String allowedResponse : allowedResponses) {
            final String[] values =
                new String[]{"0", "0", "0", allowedResponse.substring(0, allowedResponse.indexOf("."))};
            if (responseTallies.containsKey(allowedResponse) && getTotalNumberOfResponses() > 0) {
                values[0] = Long.toString(responseTallies.get(allowedResponse));
                values[1] =
                    Float.toString(responseTallies.get(allowedResponse).floatValue() / getTotalNumberOfResponses());
                values[2] =
                    Float.toString(responseTallies.get(allowedResponse).floatValue() * 100
                            / getTotalNumberOfResponses());
                this.ratingResults.add(values);

            } else {
                this.ratingResults.add(values);
            }
        }
    }

    @Override
    public boolean getCanUserRespond() {
        return this.rating.canUserRespond();
    }

}
