/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.jcr.RepositoryException;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.tally.Poll;
import com.adobe.cq.social.tally.Tally;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.ugcbase.CollabUser;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;

public class AbstractTally extends BaseSocialComponent implements TallySocialComponent {
    final private Resource resource;
    protected Tally<?> tally;
    protected final String currentUser;
    /**
     * Logger.
     */
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTally.class);

    public AbstractTally(final Resource resource, final ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.resource = resource;
        final ResourceResolver resolver = this.resource.getResourceResolver();
        if (resolver.isResourceType(this.resource, Poll.RESOURCE_TYPE)) {
            this.tally = resource.adaptTo(Poll.class);
        } else if (resolver.isResourceType(this.resource, VotingSocialComponent.VOTING_RESOURCE_TYPE)) {
            this.tally = resource.adaptTo(Voting.class);
        } else {
            this.tally = null;
        }
        this.currentUser = resolver.getUserID();
    }

    @Override
    public String getName() {
        return this.tally.getName();
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return this.tally.getTotalNumberOfResponses();
    }

    @Override
    public ResponseValue getCurrentUserResponse() throws TallyException {
        try {
            if (clientUtils.userIsAnonymous()) {
                return null;
            }

            final Response<?> resp = this.tally.getUserResponse(this.currentUser);
            if (resp == null) {
                return null;
            }
            return resp.getResponseValue();
        } catch (final RepositoryException e) {
            return null;
        }
    }

    @Override
    public Map<String, Long> getResponseTallies() {
        final Map<String, Long> local = new HashMap<String, Long>();
        final Map<ResponseValue, Long> responses = (Map<ResponseValue, Long>) this.tally.getResponseTallies();
        for (final Entry<ResponseValue, Long> entry : responses.entrySet()) {
            local.put(entry.getKey().getResponseValue(), entry.getValue());
        }
        return local;
    }

    @Deprecated
    public void addResponse(final String value) {
        try {
            this.tally.setUserResponse(this.currentUser, value);
        } catch (final TallyException e) {
        } catch (final RepositoryException e) {
        }
    }

    @Deprecated
    public void removeCurrentUserResponse() {
        try {
            this.tally.unsetUserResponse(this.currentUser);
        } catch (final TallyException e) {
        } catch (final RepositoryException e) {
        }
    }

    @Override
    public boolean getCanUserRespond() {
        return this.tally.canUserRespond();
    }

    public String getFriendlyUrl() {
        SocialUtils socialUtils = clientUtils.getSocialUtils();
        if (socialUtils != null) {
            Page page = socialUtils.getContainingPage(resource);
            if (page != null) {
                return clientUtils.externalLink(page.getPath(), false) + ".html";
            } else {
                return clientUtils.externalLink(resource.getPath(), false) + ".html";
            }
        } else {
            return null;
        }
    }
}
