/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.api;

import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.tally.TallyConstants;

public abstract class AbstractTallyResponse extends BaseSocialComponent implements TallyResponseSocialComponent {

    private final Response<? extends ResponseValue> response;
    protected final Resource resource;

    public AbstractTallyResponse(final Resource resource, final ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.resource = resource;
        this.response = getResponseFromResource();
    }

    protected ResponseValue getResponseValue(final String response) {
        return new ResponseValue() {
            @Override
            public String getResponseValue() {
                return response;
            }
        };
    }

    public AbstractTallyResponse(final Response<? extends ResponseValue> response, final ClientUtilities clientUtils) {
        super(response.getResource(), clientUtils);
        this.response = response;
        this.resource = response.getResource();
    }

    @Override
    public User getAuthor() {
        if (StringUtils.isEmpty(this.response.getUserId())) {
            return null;
        }
        return this.clientUtils.getUser(this.response.getUserId(), this.resource.getResourceResolver());
    }

    @Override
    public String getResponse() {
        return response.getResponseValue() == null ? null : response.getResponseValue().getResponseValue();
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    private Response<ResponseValue> getResponseFromResource() {
        final ValueMap vm = resource.adaptTo(ValueMap.class);
        return new Response() {

            @Override
            public String getUserId() {
                return vm.get(TallyConstants.USER_PROPERTY, "");
            }

            @Override
            public ResponseValue getResponseValue() {
                return AbstractTallyResponse.this.getResponseValue(vm.get(TallyConstants.RESPONSE_PROPERTY, ""));
            }

            @Override
            public Long getTimeStamp() {
                return vm.get(TallyConstants.TIMESTAMP_PROPERTY, 0L);
            }

            @Override
            public Resource getResource() {
                return resource;
            }

        };
    }
}
