/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.api;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.ugcbase.CollabUser;

public class AbstractVoting extends AbstractTally implements VotingSocialComponent {
    private Voting votingComponent;

    public AbstractVoting(final Resource resource) {
        this(resource, null);
    }

    public AbstractVoting(final Resource resource, final ClientUtilities clientUtils) {
        super(resource, clientUtils);
        initComponent();
    }

    private void initComponent() {
        this.votingComponent = this.getResource().adaptTo(Voting.class);
        this.tally = this.votingComponent;
    }

    @Override
    public long getNetCount() {
        return this.votingComponent.getPositiveCount() - this.votingComponent.getNegativeCount();
    }

    @Override
    public long getPositiveCount() {
        return this.votingComponent.getPositiveCount();
    }

    @Override
    public long getNegativeCount() {
        return this.votingComponent.getNegativeCount();
    }

    @Override
    public String getPositiveLabel() {
        return this.votingComponent.getPositiveLabel();
    }

    @Override
    public String getNegativeLabel() {
        return this.votingComponent.getNegativeLabel();
    }

    @Override
    public boolean isCurrentUserLike() {
        try {
            if (clientUtils.userIsAnonymous()) {
                return false;
            }

            final Response<Vote> resp = this.votingComponent.getUserResponse(this.currentUser);
            if (resp == null) {
                return false;
            }
            return Vote.LIKE.equals(resp.getResponseValue()) ? true : false;
        } catch (final RepositoryException e) {
            return false;
        } catch (final TallyException e) {
            return false;
        }
    }
}
