/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally.client.api;

public class PollResponse implements ResponseValue {

    private final String responseValue;

    public PollResponse(final String responseValue) {
        this.responseValue = responseValue;
    }

    @Override
    public String getResponseValue() {
        return this.responseValue;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((responseValue == null) ? 0 : responseValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PollResponse other = (PollResponse) obj;
        if (responseValue == null) {
            if (other.responseValue != null) {
                return false;
            }
        } else if (!responseValue.equals(other.responseValue)) {
            return false;
        }
        return true;
    }

}
