/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally.client.api;

/**
 * Represents the rating given by the user.
 */
public class Rating implements ResponseValue {

    /**
     * The value of the user's rating.
     */
    private Float rating;

    /**
     * Represents the rating given by the user.
     * @param rating String representation of the value of this particular rating
     * @param maximum The maximum value that this rating can have
     * @param minimum The minimum value that this rating can have
     */
    public Rating(final String rating, final Float maximum, final Float minimum) {
        try {
            this.rating = Float.parseFloat(rating);
        } catch (final NumberFormatException e) {
            this.rating = 0.0f;
        }
        this.rating = this.rating > maximum ? maximum : this.rating;
        this.rating = this.rating < minimum ? minimum : this.rating;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getResponseValue() {
        return String.valueOf(this.rating);
    }

    /**
     * Gets the user rating as a float value.
     * @return the float value of this rating
     */
    public Float getRating() {
        return rating;
    }

}
