/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally.client.api;

import java.util.List;

/**
 * SocialComponent for Ratings.
 */
public interface RatingSocialComponent extends TallySocialComponent {

    public static final String RATING_RESOURCE_TYPE = "social/tally/components/hbs/rating";

    /**
     * @return the average rating
     */
    Float getAverageRating();

    /**
     * @return the formatted average rating in String
     */
    String getFormattedAverageRating();

    /**
     * @return a map of all Responses and the number of votes and percentage of votes for each.
     */
    List<String[]> getRatingResults();

}
