/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.api;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.tally.client.impl.RatingSocialComponentImpl;
import com.adobe.granite.xss.XSSAPI;

/**
 * Default SocialComponentFactory for Ratings.
 */
@Component
@Service
public class RatingSocialComponentFactory extends AbstractSocialComponentFactory implements SocialComponentFactory {

    private static final String RATING_RESOURCE_TYPE = "social/tally/components/hbs/rating";

    @Reference
    private XSSAPI xss;

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return new RatingSocialComponentImpl(resource, this.getClientUtilities(resource.getResourceResolver()));
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        return new RatingSocialComponentImpl(resource, this.getClientUtilities(request));
    }

    @Override
    public String getSupportedResourceType() {
        return RATING_RESOURCE_TYPE;
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo queryInfo) {
        return new RatingSocialComponentImpl(resource, clientUtils);
    }

}
