/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally.client.api;

import org.apache.sling.api.resource.Resource;

/**
 * A Response object holds the state of a user response to a tally.
 * @param <T> A ResponseValue object that holds the value of the user response
 */
public interface Response<T extends ResponseValue> {
    /**
     * @return the authorizable ID of the user who create the response
     */
    String getUserId();

    /**
     * @return the response string itself.
     */
    T getResponseValue();

    /**
     * @return the timestamp for when this response was created.
     */
    Long getTimeStamp();

    /**
     * @return the Resource node for this response.
     */
    Resource getResource();

}
