/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.api;

import java.util.Map;

import com.adobe.cq.social.scf.SocialComponent;

/**
 * Social Component for any {@link com.adobe.cq.social.tally.Tally} resource.
 */
public interface TallySocialComponent extends SocialComponent {
    /**
     * @return The name of the tally component.
     */
    String getName();

    /**
     * @return the total number of responses to this tally.
     */
    Long getTotalNumberOfResponses();

    /**
     * @return the current users response given a session.
     * @throws TallyException if there was an error retrieving the current users response.
     */
    ResponseValue getCurrentUserResponse() throws TallyException;

    /**
     * @return a map of all responses to number of users who have chosen the response.
     */
    Map<String, Long> getResponseTallies();

    /**
     * @return true if the logged in user can respond to the tally, false otherwise.
     */
    boolean getCanUserRespond();
}
