/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.tally.client.api;

/**
 * Represents the vote given by a user.
 */
public enum Vote implements ResponseValue {
    /**
     * A positive vote.
     */
    LIKE("1"),
    /**
     * A negative vote.
     */
    DISLIKE("-1");
    /**
     * The string value of the vote.
     */
    private String responseValue;

    /**
     * @param responseValue String representation of the user's vote (1 or -1)
     */
    Vote(final String responseValue) {
        this.responseValue = responseValue;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getResponseValue() {
        return this.responseValue;
    }

    /**
     * @param responseValue String representation of the Vote value
     * @return a strongly typed Vote value representing the response value
     */
    public static Vote getVoteByResponseValue(final String responseValue) {
        for (final Vote v : Vote.values()) {
            if (v.getResponseValue().equals(responseValue)) {
                return v;
            }
        }
        return null;
    }
}
