/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.api;

/**
 * SocialComponent for {@link com.adobe.cq.social.tally.Voting}.
 */
public interface VotingSocialComponent extends TallySocialComponent {

    public static final String VOTING_RESOURCE_TYPE = "social/tally/components/hbs/voting";

    /**
     * @return the net vote count, number of positive votes minus number of negative votes.
     */
    long getNetCount();

    /**
     * @return the number of positive votes.
     */
    long getPositiveCount();

    /**
     * @return the number of negative votes.
     */
    long getNegativeCount();

    /**
     * @return the label for the positive response
     */
    String getPositiveLabel();

    /**
     * @return the label for the negative response
     */
    String getNegativeLabel();

    /**
     * @return true if current user vote is postive, false if current user vote is negative or if current user has not
     *         voted.
     */
    boolean isCurrentUserLike();
}
