/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.tally.client.endpoints;

import java.util.Map;

import javax.jcr.Session;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.OperationException;

/**
 * A service that performs operations on a tally component.
 */
public interface TallyOperationsService {

    /**
     * Tally type string for Rating.
     */
    public static final String RATING = "Rating";
    /**
     * Tally type string for Voting.
     */
    public static final String VOTING = "Voting";
    /**
     * Tally type string for Polls.
     */
    public static final String POLL = "Poll";

    /**
     * Sets the response for the current user. Current user is figured out from the session using which the resource
     * was obtained.
     * @param tallyResource the tally resource on which the response is added.
     * @param responseValue the response value to set.
     * @return the response resource.
     * @throws OperationException when an error occurs.
     */
    Resource addCurrentUserResponseResponse(Resource tallyResource, String responseValue, String tallyType)
        throws OperationException;

    /**
     * @param tallyResource the tally resource on which the response is added.
     * @throws OperationException when an error occurs.
     */
    void removeCurrentUserResponse(Resource tallyResource, String tallyType) throws OperationException;

    /**
     * @param request the request that triggered this operation.
     * @return the response resource.
     * @throws OperationException if an error occurs.
     */
    Resource setResponse(SlingHttpServletRequest request) throws OperationException;

    /**
     * Allows setting a tally response for an arbitrary user of caller's choice. Needed this method made public for
     * migrating tally content.
     * @param tally
     * @param author
     * @param session
     * @param tallyResponse
     * @param tallyType
     * @param parameters
     * @return
     * @throws OperationException
     */
    Resource setTallyResponse(final Resource tally, final String author, final Session session,
        final String tallyResponse, final String tallyType, final Map<String, Object> parameters)
        throws OperationException;
}
