/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

/**
 * AbstractConstraint provides implementations for functionality common to most Constraints.
 */
public abstract class AbstractConstraint implements Constraint {

    /**
     * The operator used to join this constraint with other constraints.
     */
    private Operator operator;

    /**
     * Whether or not this constraint has been negated.
     */
    private boolean negated;

    /**
     * Creates a new instance of AbstractConstraint which is AND'd with other constraints.
     */
    public AbstractConstraint() {
        this(Operator.And);
    }

    /**
     * Creates a new instance of AbstractConstraint with the given operator.
     * @param operator Operator defines how this constraint is joined with other constraints.
     */
    public AbstractConstraint(final Operator operator) {
        super();
        this.operator = operator;
    }

    /**
     * Sets the operator used to join this constraint with other constraints.
     * @param operator And Operator or Or Operator.
     */
    @Override
    public void setOperator(final Operator operator) {
        this.operator = operator;
    }

    /**
     * Gets the operator used to join this constraint with other constraints.
     * @return Operator used to join this constraint with other constraints.
     */
    @Override
    public Operator getOperator() {
        return this.operator;
    }

    /**
     * Negates this constraint.
     */
    @Override
    public void negate() {
        this.negated = true;
    }

    /**
     * Checks whether this constraint has been negated.
     * @return True if this constraint has been negated, false otherwise.
     */
    @Override
    public boolean isNegated() {
        return this.negated;
    }
}
