/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

/**
 * AbstractPropertyConstraint provides functionality common to constraints which apply to a specific property.
 */
public abstract class AbstractPropertyConstraint extends AbstractConstraint implements Constraint {

    /**
     * Name of the property this constraint applies to.
     */
    private final String name;

    /**
     * Creates a new instance of AbstractPropertyConstraint with the given name and operator.
     * @param name String containing the name of the property this constraint applies to.
     * @param operator Operator which defines how this constraint is joined with other constraints.
     */
    public AbstractPropertyConstraint(final String name, final Operator operator) {
        super(operator);
        this.name = name;
    }

    /**
     * Gets the name of the property this constraint applies to.
     * @return String containing the name of the property.
     */
    public String getPropertyName() {
        return this.name;
    }

}
