/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugc.api;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.Event;

import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;

/**
 * Default implementation of UgcNodeIndexerExtension.
 */
@Component(componentAbstract = true)
@Deprecated
public abstract class AbstractUgcNodeIndexerExtension implements UgcNodeIndexerExtension {

    /**
     * The primary type constant.
     */
    private static final String primaryType = "jcr:primaryType";

    /**
     * The UUID constant.
     */
    private static final String FIELD_UUID = ":uuid";

    /**
     * The primary type field.
     */
    private static final String FIELD_PRIMARY_TYPE = primaryType;

    /**
     * The path field.
     */
    private static final String FIELD_PATH = ":path";

    /**
     * The parent field.
     */
    private static final String FIELD_PARENT = ":parent";

    /**
     * The name field.
     */
    private static final String FIELD_NAME = ":name";

    /**
     * The local field.
     */
    private static final String FIELD_LOCAL = ":local";

    /**
     * The enabled property.
     */
    @org.apache.felix.scr.annotations.Property(boolValue = true)
    public static final String PROP_ENABLED = "indexer.extension.enabled";

    /**
     * If !enabled, skip indexing process (don't listen for events).
     */
    protected boolean enabled = false;

    /**
     * Check the primary type and return true if the node belongs in this index.
     * @param primaryType the node type to check.
     * @return true if the node belongs in this index.
     */
    @Override
    public boolean checkPrimaryType(final NodeType primaryType) {
        return true;
    }

    /**
     * Check the resource type and return true if the node belongs in this index.
     * @param resourceType the resource type to check.
     * @return true if the node belongs in this index.
     */
    @Override
    public boolean checkResourceType(final String resourceType) {
        return true;
    }

    /**
     * Check the resource and return true if the node belongs in this index.
     * @param resource the resource to check.
     * @return true if the node belongs in this index.
     */
    @Override
    public boolean checkResource(final Resource resource) {
        return true;
    }

    /**
     * Check the node and return true if the node belongs in this index.
     * @param node the node to check.
     * @return true if the node belongs in this index.
     */
    @Override
    public boolean checkNode(final Node node) {
        return true;
    }

    /**
     * Check the event and return true if it indicates data has been modified that affects the index.
     * @param event Event to check.
     * @return true if the event indicates data has been modified that should be indexed.
     */
    @Override
    public boolean checkEventModifiesIndex(final Event event) {
        return true;
    }

    /**
     * Return true if enabled.
     * @return true if enabled.
     */
    @Override
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * For Index extensonions that would need faceted search, this method should be overridden to return true
     * @return boolean true if node extension need to implement faceted Search
     */
    @Override
    public boolean suppportFacetedSearch() {
        return false;
    }

    /**
     * Given a node, return a list of UgcIndexProperties.
     * @param resolver the ResourceResolver.
     * @param node the node being indexed.
     * @return a list of UgcIndexProperties.
     * @throws RepositoryException thrown if there are issues with repository.
     */
    @Override
    public List<UgcIndexProperty> getAllUgcIndexProperties(final ResourceResolver resolver, final Node node)
        throws RepositoryException {
        final List<UgcIndexProperty> result = new LinkedList<UgcIndexProperty>();

        result.add(new UgcIndexProperty(FIELD_UUID, node.getIdentifier(), true,
            UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        result.add(new UgcIndexProperty(FIELD_PRIMARY_TYPE, node.getPrimaryNodeType().getName(), true,
            UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));

        result.add(new UgcIndexProperty(FIELD_PATH, node.getPath(), true,
            UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        try {
            result.add(new UgcIndexProperty(FIELD_PARENT, node.getParent().getPath(), false,
                UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        } catch (final RepositoryException e) {
            // ignore; root node has no parent
        }

        String name = node.getName();
        result.add(new UgcIndexProperty(FIELD_NAME, name, false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));
        name = name.substring(name.indexOf(':') + 1);
        result.add(new UgcIndexProperty(FIELD_LOCAL, name, false, UgcIndexProperty.Index.NOT_ANALYZED_NO_NORMS));

        result.addAll(getUgcIndexProperties(resolver, node));
        return result;
    }

    /**
     * Given a node, return a list of UgcIndexProperties. Implemented by subclass to include custom index properties.
     * @param resolver the ResourceResolver.
     * @param node the node being indexed.
     * @return a list of UgcIndexProperties.
     * @throws RepositoryException thrown if there are issues with repository.
     */
    public abstract List<UgcIndexProperty> getUgcIndexProperties(ResourceResolver resolver, Node node)
        throws RepositoryException;

    /**
     * Given a node, return a list of Ugc Indexed Categories. Implemented by subclass to include custom index
     * Categories.Also suppportFacetedSearch() should be overridden return true This method should be overridden -
     * check JournalUgcNodeIndexerExtension in com.adobe.cq.social.journal.impl for sample implementation
     * @param resolver the ResourceResolver.
     * @param node the node being indexed.
     * @return a list of UgcIndexCategories.
     * @throws RepositoryException thrown if there are issues with repository.
     */
    @Override
    public List<UgcCategoryProperty> getUgcIndexedCategories(final ResourceResolver resolver, final Node node)
        throws RepositoryException {
        return null;
    }

    /**
     * Reads configuration from the given map of properties.
     * @param properties Map containing configuration properties.
     */
    protected void readConfiguration(final Map<String, Object> properties) {
        enabled = OsgiUtil.toBoolean(properties.get(PROP_ENABLED), true);
    }

}
