/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

/**
 * Defines a restriction as part of a query.
 */
public interface Constraint {

    /**
     * Gets the operator which defines whether.
     * @return the operation used by this constraint.
     */
    Operator getOperator();

    /**
     * Sets the operator for this constraint. The operator defines whether this constraint is combined with other
     * constraints as an AND or an OR.
     * @param operator And Operator or Or Operator.
     */
    void setOperator(Operator operator);

    /**
     * Negates the constraint.
     */
    void negate();

    /**
     * Gets whether or not this constraint has been negated.
     * @return true if the constraint has been negated, false otherwise.
     */
    boolean isNegated();

    /**
     * Accepts a ConstraintVisitor so that it may travers a constraint hierarchy.
     * @param constraintVisitor ConstraintVisitor to accept.
     */
    void accept(ConstraintVisitor constraintVisitor);

}
