/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

import java.util.Collection;
import java.util.Vector;

/**
 * Defines a grouping of constraints.
 */
public class ConstraintGroup extends AbstractConstraint implements Constraint {

    /**
     * The collection of constraints.
     */
    private Collection<Constraint> constraints;

    /**
     * Construct a new ConstraintGroup.
     */
    public ConstraintGroup() {
        this(Operator.And);
    }

    /**
     * Construct a new ConstraintGroup with the given operator.
     * @param operator the operator for this group.
     */
    public ConstraintGroup(final Operator operator) {
        super(operator);
    }

    /**
     * Add a constraint to the group, joined with an AND operator.
     * @param constraint the constraint to add.
     */
    public void and(final Constraint constraint) {
        constraint.setOperator(Operator.And);
        addConstraint(constraint);
    }

    /**
     * Add a constraint to the group, joined with an OR operator.
     * @param constraint the constraint to add.
     */
    public void or(final Constraint constraint) {
        constraint.setOperator(Operator.Or);
        addConstraint(constraint);
    }

    /**
     * Add a constraint to the group.
     * @param constraint the constraint to add.
     */
    public void addConstraint(final Constraint constraint) {
        if (null == this.constraints) {
            this.constraints = new Vector<Constraint>();
        }
        this.constraints.add(constraint);
    }

    /**
     * Return the collection of constraints in this group.
     * @return the collection of constraints in this group.
     */
    public Collection<Constraint> getConstraints() {
        return this.constraints;
    }

    /**
     * Visit this constraint group.
     * @param constraintVisitor the ConstraintVisitor.
     */
    @Override
    public void accept(final ConstraintVisitor constraintVisitor) {
        constraintVisitor.visitConstraintGroup(this);
    }

    /**
     * Return true if this group has constraints.
     * @return true if this group has constraints.
     */
    public boolean hasConstraints() {
        return null != this.constraints && 0 < this.constraints.size();
    }
}
