/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

/**
 * ConstraintVisitor implementations can be used to travers a set of constraints.
 */
public interface ConstraintVisitor {

    /**
     * This method is called when the ConstraintVisitor is passed to the accept method of a PathConstraint.
     * @param pathConstraint PathConstraint being visited.
     */
    void visitPathConstraint(PathConstraint pathConstraint);

    /**
     * This method is called when the ConstraintVisitor is passed to the accept method of a ValueConstraint.
     * @param valueConstraint ValueConstraint being visited.
     */
    void visitValueConstraint(ValueConstraint<? extends Object> valueConstraint);

    /**
     * This method is called when the ConstraintVisitor is passed to the accept method of a ConstraintGroup.
     * @param constraintGroup ConstraintGroup being visited.
     */
    void visitConstraintGroup(ConstraintGroup constraintGroup);

    /**
     * This method is called when the ConstraintVisitor is passed to the accept method of a RangeConstraint. .
     * @param rangeConstraint RangeConstraint being visited.
     */
    void visitRangeConstraint(RangeConstraint<? extends Object> rangeConstraint);

    /**
     * This method is called when the ConstraintVisitor is passed to the accept method of a SetConstraint.
     * @param propertySetConstraint SetConstraint being visited.
     */
    void visitSetConstraint(SetConstraint<? extends Object> propertySetConstraint);

    /**
     * This method is called when the ConstraintVisitor is passed to the accept method of a FullTextConstraint.
     * @param fullTextConstraint FullTextConstraint being visited.
     */
    void visitFullTextConstraint(FullTextConstraint fullTextConstraint);
}
