/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

/**
 * DefaultConstraintVisitor provides empty no-op method implementations for all ConstraintVisitor methods.
 */
public class DefaultConstraintVisitor implements ConstraintVisitor {

    /**
     * No-op method for visitPathConstraint.
     * @param pathConstraint PathConstraint being visited.
     */
    @Override
    public void visitPathConstraint(final PathConstraint pathConstraint) {

    }

    /**
     * No-op method for visitValueConstraint.
     * @param valueConstraint ValueConstraint being visited.
     */
    @Override
    public void visitValueConstraint(final ValueConstraint<? extends Object> valueConstraint) {

    }

    /**
     * No-op method for visitConstraintGroup.
     * @param constraintGroup ConstraintGroup being visited.
     */
    @Override
    public void visitConstraintGroup(final ConstraintGroup constraintGroup) {

    }

    /**
     * No-op method for visitRangeConstraint.
     * @param rangeConstraint RangeConstraint being visited.
     */
    @Override
    public void visitRangeConstraint(final RangeConstraint<? extends Object> rangeConstraint) {

    }

    /**
     * No-op method for visitSetConstraint.
     * @param propertySetConstraint SetConstraint being visited.
     */
    @Override
    public void visitSetConstraint(final SetConstraint<? extends Object> propertySetConstraint) {

    }

    /**
     * No-op method for visitFullTextConstraint.
     * @param fullTextConstraint FullTextConstraint being visited.
     */
    @Override
    public void visitFullTextConstraint(final FullTextConstraint fullTextConstraint) {

    }

}
