/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

/**
 * PathConstraint defines a constraint on the path of a node. The type of the path constraint is defined by the
 * {@link PathConstraintType PathConstraintType} enum.
 */
public class PathConstraint extends AbstractConstraint implements Constraint {

    /**
     * Path of the constraint.
     */
    private String path;

    /**
     * Type of constraint being placed on the path.
     */
    private final PathConstraintType pathConstraintType;

    /**
     * Creates a new instance of PathConstraint with the given path, path constraint and an AND operator.
     * @param path String containing the path for this constraint.
     * @param pathConstraintType PathConstraintType defining the type of constraint being based on the path.
     */
    public PathConstraint(final String path, final PathConstraintType pathConstraintType) {
        this(path, pathConstraintType, Operator.And);
    }

    /**
     * Creates a new instance of PathConstraint.
     * @param path String containing the path for this constraint.
     * @param pathConstraintType PathConstraintType defining the type of constraint being based on the path.
     * @param operator Operator defining how this constraint is joined with other constraints.
     */
    public PathConstraint(final String path, final PathConstraintType pathConstraintType, final Operator operator) {
        super(operator);
        this.path = path;
        this.pathConstraintType = pathConstraintType;
    }

    /**
     * Gets the type of constraint being placed on the path.
     * @return PathConstraintType defining what kind of constraint is being placed on the path.
     */
    public PathConstraintType getPathConstraintType() {
        return this.pathConstraintType;
    }

    /**
     * Gets the path for this constraint.
     * @return String containing the path for this constraint.
     */
    public String getPath() {
        return this.path;
    }

    /**
     * Sets the path for this constraint. Used when mapping a path having /content constraint to a UGC constraint
     */
    public void setPath(final String path) {
        this.path = path;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void accept(final ConstraintVisitor constraintVisitor) {
        constraintVisitor.visitPathConstraint(this);
    }
}
