/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

import java.util.List;

/**
 * Search results interface.
 * @param <T> the type of objects in the search results.
 */
public interface SearchResults<T> {

    /**
     * Return the total number of search results if 'requiresTotal' is true or if limit is 0 when find is called. If
     * 'requiresTotal' is false and there is additional matching content available, this will return a value greater
     * than limit. If 'requiresTotal' is false and there is no additional matching content, this will return limit.
     * @return the total number of search results.
     * @see UgcSearch#find(String, org.apache.sling.api.resource.ResourceResolver, UgcFilter, int, int, boolean)
     */
    long getTotalNumberOfResults();

    /**
     * Return the list of search results.
     * @return the list of search results.
     */
    List<T> getResults();

}
