/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugc.api;

/**
 * A UGC catagory property.
 */
public class UgcCategoryProperty {

    /**
     * The property key.
     */
    private final String key;

    /**
     * The property value.
     */
    private final String value;

    /**
     * Construct a UgcCategoryProperty.
     * @param aKey the property key.
     * @param aValue the property value.
     */
    public UgcCategoryProperty(final String aKey, final String aValue) {
        key = aKey;
        value = aValue;
    }

    /**
     * Return the property key.
     * @return the property key.
     */
    public String key() {
        return key;
    }

    /**
     * Return the property value.
     * @return the property value.
     */
    public String value() {
        return value;
    }

}
