/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugc.api;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.Event;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Interface class for extension of node indexing. Service implementations of this interface are no longer honored as
 * of AEM 6.1
 */
@Deprecated
public interface UgcNodeIndexerExtension {

    /**
     * Check the primary type and return true if the node belongs in this index.
     * @param primaryType the node type to check.
     * @return true if the node belongs in this index.
     */
    boolean checkPrimaryType(NodeType primaryType);

    /**
     * Check the resource type and return true if the node belongs in this index.
     * @param resourceType the resource type to check.
     * @return true if the node belongs in this index.
     */
    boolean checkResourceType(String resourceType);

    /**
     * Check the resource and return true if the node belongs in this index.
     * @param resource the resource to check.
     * @return true if the node belongs in this index.
     */
    boolean checkResource(Resource resource);

    /**
     * Check the node and return true if the node belongs in this index.
     * @param node the node to check.
     * @return true if the node belongs in this index.
     */
    boolean checkNode(Node node);

    /**
     * Check the event and return true if it indicates data has been modified that affects the index.
     * @param event Event to check.
     * @return true if the event indicates data has been modified that should be indexed.
     */
    boolean checkEventModifiesIndex(Event event);

    /**
     * Given a node, return a list of UgcIndexProperties.
     * @param resolver the ResourceResolver.
     * @param node the node being indexed.
     * @return a list of UgcIndexProperties.
     * @throws RepositoryException thrown if there are issues with repository.
     */
    List<UgcIndexProperty> getAllUgcIndexProperties(ResourceResolver resolver, Node node) throws RepositoryException;

    /**
     * Given a node, return a list of Ugc Indexed Categories. Implemented by subclass to include custom index
     * Categories. Also suppportFacetedSearch() should return true
     * @param resolver the ResourceResolver.
     * @param node the node being indexed.
     * @return a list of UgcIndexCategories.
     * @throws RepositoryException thrown if there are issues with repository.
     */
    List<UgcCategoryProperty> getUgcIndexedCategories(ResourceResolver resolver, Node node)
        throws RepositoryException;

    /**
     * Return the name of the index.
     * @return the name of the index.
     */
    String getName();

    /**
     * Return the node types that should be observed for events to trigger indexing.
     * @return the node types that should be observed for events to trigger indexing.
     */
    String[] getPrimaryTypes();

    /**
     * Return the include paths that should be observed for events to trigger indexing. This is in comma separated
     * value format.
     * @return the include paths that should be observed for events to trigger indexing.
     */
    String getIncludePaths();

    /**
     * For Index extensonions that would need faceted search, this method should be overridden to return true.
     * @return boolean true if node extension need to implement faceted Search.
     */
    boolean suppportFacetedSearch();

    /**
     * Is this indexer extension enabled?
     * @return true if enabled.
     */
    boolean isEnabled();
}
