/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugc.api;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Interface for UGC search.
 */
public interface UgcSearch {

    /**
     * Perform a basic search.
     * @param scName the name of the search collection.
     * @param session the user session.
     * @param filter the query filters.
     * @param offset the result offset.
     * @param limit the result limit.
     * @return the search results as Nodes.
     * @throws RepositoryException thrown when there are issues with repository.
     * @deprecated use {@link UgcSearch#find(String, ResourceResolver, UgcFilter, int, int, boolean)}
     */
    @Deprecated
    SearchResults<Node> find(String scName, final Session session, final UgcFilter filter, int offset, int limit)
        throws RepositoryException;

    /**
     * Perform a search with a component filter returning resources. Caution: When doing a search for resources
     * managed by a SRP, you cannot use a parent/descendant constraint that is outside the SRP. This behavior will
     * change in subsequent releases.
     * @param scName the name of the search collection.
     * @param resolver the user session.
     * @param filter the query filters.
     * @param offset the result offset.
     * @param limit the result limit.
     * @return the search results.
     * @throws RepositoryException thrown when there are issues with repository.
     * @deprecated use {@link UgcSearch#find(String, ResourceResolver, UgcFilter, int, int, boolean)}
     */
    @Deprecated
    SearchResults<Resource> find(final String scName, final ResourceResolver resolver, final UgcFilter filter,
        final int offset, final int limit) throws RepositoryException;

    /**
     * Perform a search with a component filter returning resources. Caution: When doing a search for resources
     * managed by a SRP, you cannot use a parent/descendant constraint that is outside the SRP. This behavior will
     * change in subsequent releases.
     * @param scName the name of the search collection.
     * @param resolver the user session.
     * @param filter the query filters.
     * @param offset the result offset.
     * @param limit the result limit.
     * @param requiresTotal true iff the total number of matches needs to be returned in the search results
     * @return the search results.
     * @throws RepositoryException thrown when there are issues with repository.
     */
    SearchResults<Resource> find(final String scName, final ResourceResolver resolver, final UgcFilter filter,
        final int offset, final int limit, final boolean requiresTotal) throws RepositoryException;

    /**
     * Perform a search with a component filter returning resources. Caution: When doing a search for resources
     * managed by a SRP, you cannot use a parent/descendant constraint that is outside the SRP. This behavior will
     * change in subsequent releases.
     * @param scName the name of the search collection.
     * @param resolver the user session.
     * @param filter the query filters.
     * @param offset the result offset.
     * @param limit the result limit.
     * @param requiresTotal true iff the total number of matches needs to be returned in the search results
     * @param fieldLanguage search will be queried against verbatim_fieldLanguage. This can be changed in the SOLR
     *            request handler.
     * @return the search results.
     * @throws RepositoryException thrown when there are issues with repository.
     */
    SearchResults<Resource> find(final String scName, final ResourceResolver resolver, final UgcFilter filter,
        final int offset, final int limit, final boolean requiresTotal, final String fieldLanguage)
        throws RepositoryException;

    /**
     * Return the index of the target in the search result.
     * @param scName the name of the search collection.
     * @param session the user session.
     * @param listing the query filters.
     * @param targetPath the path of the target.
     * @param added the date that the target was added.
     * @return the index of the target in the search result.
     * @throws RepositoryException thrown when there are issues with repository.
     */
    int getIndex(String scName, final Session session, final UgcFilter listing, String targetPath, long added)
        throws RepositoryException;

}
