/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugc.api;

/**
 * Used to specify sort direction.
 */
public class UgcSort {

    /**
     * Sort direction types.
     */
    public enum Direction {
        /**
         * Ascending.
         */
        Asc,
        /**
         * Descending.
         */
        Desc
    };

    /**
     * The direction.
     */
    private final Direction direction;

    /**
     * The property name.
     */
    private final String propertyName;

    /**
     * Construct a UgcSort.
     * @param propertyName the name of the property.
     * @param direction the sort direction.
     */
    public UgcSort(final String propertyName, final Direction direction) {
        super();
        this.direction = direction;
        this.propertyName = propertyName;
    }

    /**
     * Return the property name.
     * @return the property name.
     */
    public String getPropertyName() {
        return this.propertyName;
    }

    /**
     * Return true if ascending.
     * @return true if ascending.
     */
    public boolean isAscending() {
        return direction == Direction.Asc;
    }

}
