/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase;

import java.util.List;

import org.apache.felix.scr.annotations.Component;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.replication.ReplicationActionType;

@ProviderType
@Component(metatype = true, immediate = true, label = "%asyncreversereplicator.name",
        description = "%asyncreversereplicator.description")
/**
 * <code>AsyncReverseReplicator</code> represents an async reverse replicator .
 */
public interface AsyncReverseReplicator {

    /**
     * Reverse replicate the specified path.
     * @param path The path for reverse replicate
     */
    void reverseReplicate(final String path);

    /**
     * Triggers reverse replication for the node at the given path with the specified action type.
     * @param actionType replication action type
     * @param path path of node to replicate
     */
    void reverseReplicate(final ReplicationActionType actionType, final String path);

    /**
     * Triggers reverse replication for the node at the given path with the specified action type.
     * @param actionType replication action type
     * @param paths the paths you want to replicate
     */
    void reverseReplicate(final ReplicationActionType actionType, final List<String> paths);
}
