/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugcbase;

import java.util.Map;

import com.adobe.cq.social.srp.APIResult;

/**
 * An APIResult instance that contains an attachment.
 */
public class AttachmentResult extends APIResult {

    /**
     * The attachment returned by a read/fetch operation.
     */
    private final Map<String, Object> attachment;

    /**
     * Set the attachment and result values.
     * @param attachment - a map expressing the attachment metadata retrieved from storage.
     */
    public AttachmentResult(final Map<String, Object> attachment) {
        this.setResult(true);
        this.attachment = attachment;
    }

    /**
     * Get the attachment.
     * @return Map of data.
     */
    public Map<String, Object> getAttachment() {
        return this.attachment;
    }
}
