/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase;

import com.adobe.cq.social.SocialException;

/**
 * <code>CollabUser</code> represents a user in Social Collaboration applications.
 */
public interface CollabUser {

    /**
     * The name for an anonymous user.
     */
    static final String ANONYMOUS = "Anonymous";

    /**
     * The property name for the user name.
     */
    static final String PROP_NAME = "userIdentifier";

    /**
     * The property name for the website URL.
     */
    final static String PROP_WEBSITE = "url";

    /**
     * The property name for the email address.
     */
    final static String PROP_EMAIL = "email";

    /**
     * Returns the identifier of the user.
     * @return the ID
     */
    String getId();

    /**
     * Returns the name of the user. If undefined, The ID will be used.
     * @return the name
     */
    String getName();

    /**
     * Sets the name of the user.
     * @param name The user name
     */
    void setName(String name);

    /**
     * Returns the email address of the user.
     * @return the email address
     */
    String getEmail();

    /**
     * Sets the email address of the user.
     * @param email The email address
     */
    void setEmail(String email);

    /**
     * Returns the URL of the user's website.
     * @param defaultUrl The default URL to use if undefined
     * @return the website
     */
    String getWebsite(String defaultUrl);

    /**
     * Sets the URL of the user's website.
     * @param website The website
     */
    void setWebsite(String website);

    /**
     * Returns the URL to the user's gravatar image. See <a href="http://en.gravatar.com">http://en.gravatar.com</a>
     * for more information about gravatars.
     * @param defaultImage The default image to display if no gravatar is available
     * @return The Gravatar
     */
    String getGravatar(String defaultImage);

    /**
     * Returns whether this user has been modified and needs to be saved.
     * @see #save()
     * @return <code>true</code> if user is modified, <code>false</code> otherwise
     */
    boolean isModified();

    /**
     * Saves all changes made to this user. In case the user doesn't exist yet, it will be created.
     * @throws CollabException if saving fails
     */
    void save() throws SocialException;

}
