/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugcbase;

import java.util.Map;

import com.adobe.cq.social.srp.APIResult;

/**
 * An APIResult instance that contains a document.
 */
public class DocumentResult extends APIResult {

    /**
     * The document returned by a read/fetch operation.
     */
    private final Map<String, Object> document;

    /**
     * Set the document and result values.
     * @param document - a map expressing the document retrieved from storage.
     */
    public DocumentResult(final Map<String, Object> document) {
        this.setResult(true);
        this.document = document;
    }

    /**
     * Get the document.
     * @return Map of data.
     */
    public Map<String, Object> getDocument() {
        return this.document;
    }
}
