/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugcbase;

import com.adobe.cq.social.srp.APIResult;

/**
 * An APIResult instance that contains an error.
 */
public class ErrorResult extends APIResult {

    /**
     * The error code.
     */
    private final int code;

    public static final int ERROR_DOCUMENT_NOT_FOUND = 100;
    public static final int ERROR_DOCUMENT_ID_EXISTS = 101;

    public static final int ERROR_AUTHORIZATION_FAILED = 110;
    public static final int ERROR_API_ERROR = 120;
    public static final int ERROR_DATABASE_MISSING = 130;
    public static final int ERROR_INVALID_CALL = 140;
    public static final int ERROR_UNKNOWN = 0;

    /**
     * Set the error code.
     * @param code - the error code
     */
    public ErrorResult(final int code) {
        this.code = code;
        this.setResult(false);
    }

    /**
     * Accessor for the error code's value.
     * @return - the error code.
     */
    public final int getCode() {
        return this.code;
    }

    /**
     * Return a descriptive error message to match the error code.
     * @return - the error message
     */
    @Override
    public final String toString() {
        switch (this.code) {
            case ERROR_DOCUMENT_NOT_FOUND:
                return "The document could not be found.";
            case ERROR_DOCUMENT_ID_EXISTS:
                return "The document could not be created/moved because the intended document id already exists.";
            case ERROR_AUTHORIZATION_FAILED:
                return "The endpoint rejected our authorization";
            case ERROR_DATABASE_MISSING:
                return "Unable to communicate with remote database";
            case ERROR_INVALID_CALL:
                return "The call was rejected by the server for having an invalid syntax or arguments";
            default:
                return "Unknown error";
        }
    }
}
