/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/**
 * Some simple Json to java object utils.
 */
public class SocialJsonUtils {

    /**
     * Takes a json object (ie, unordered key/value data) and converts it to a java Map.
     * @param node the node to transform
     * @return the resulting Map
     * @throws org.apache.sling.commons.json.JSONException when the object can't be parsed
     */
    public static Map<String, Object> jsonObjectToMap(final JSONObject node) throws JSONException {
        final Map<String, Object> theMap = new HashMap<String, Object>();
        final Iterator<String> iterator = node.keys();

        while (iterator.hasNext()) {
            final String field = iterator.next();
            final Object o = jsonDataToObject(node, field);
            if (o != null) {
                theMap.put(field, o);
            }
        }

        return theMap;
    }

    /**
     * Takes any kind of json node and converts it to a java Object.
     * @param node the node to transform
     * @param field the field in the JSONObject to convert
     * @return the resulting object
     */
    public static Object jsonDataToObject(final JSONObject node, final String field) throws JSONException {
        final Object o = node.get(field);
        if (o instanceof JSONArray) {
            return jsonArrayToArray((JSONArray) o);
        } else if (o instanceof JSONObject) {
            return jsonObjectToMap((JSONObject) o);
        } else if (o == JSONObject.NULL) {
            return null;
        } else {
            return o;
        }
    }

    /**
     * Takes any kind of json node and converts it to a java Object.
     * @param node the node to transform
     * @param field the field in the JSONObject to convert
     * @return the resulting object
     */
    public static Object jsonDataToObject(final JSONArray node, final int field) throws JSONException {
        final Object o = node.get(field);
        if (o instanceof JSONArray) {
            return jsonArrayToArray((JSONArray) o);
        } else if (o instanceof JSONObject) {
            return jsonObjectToMap((JSONObject) o);
        } else if (o == JSONObject.NULL) {
            return null;
        } else {
            return o;
        }
    }

    /**
     * Convert a json array to a java list.
     * @param node the node to transform
     * @return the resulting List of objects
     * @throws JSONException on failure
     */
    @SuppressWarnings("rawtypes")
    public static Object[] jsonArrayToArray(final JSONArray node) throws JSONException {
        final List<Object> values = new ArrayList<Object>();
        for (int i = 0; i < node.length(); i++) {
            final Object o = jsonDataToObject(node, i);
            if (o != null) {
                values.add(o);
            }
        }

        boolean mixed = false;
        final Class first = values.size() > 0 ? values.get(0).getClass() : null;
        for (final Object o : values) {
            if (o.getClass() != first) {
                mixed = true;
                break;
            }
        }

        // Convert to array for all array types defined in UGCCPropertyResourceImpl.

        if (!mixed) {
            if (values.isEmpty()) {
                return null;
            } else if (values.get(0) instanceof String) {
                return values.toArray(new String[values.size()]);
            } else if (values.get(0) instanceof Boolean) {
                return values.toArray(new Boolean[values.size()]);
            } else if (values.get(0) instanceof Integer) {
                final Long[] longValues = new Long[values.size()];
                for (int i = 0; i < longValues.length; i++) {
                    longValues[i] = ((Integer) values.get(i)).longValue();
                }
                return longValues;
            } else if (values.get(0) instanceof Long) {
                return values.toArray(new Long[values.size()]);
            } else if (values.get(0) instanceof Double) {
                return values.toArray(new Double[values.size()]);
            } else if (values.get(0) instanceof Map) {
                return values.toArray(new Map[values.size()]);
            } else {
                return null; // return null so property will be deleted
            }
        } else {
            return values.toArray(new Object[values.size()]);
        }
    }
}
