/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.Session;

import org.apache.sling.api.SlingConstants;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;

import aQute.bnd.annotation.ProviderType;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.srp.SocialResourceProvider;
import com.adobe.cq.social.srp.config.SocialResourceConfiguration;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.translation.api.TranslationManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * Social Utilities.
 */
@Deprecated
@ProviderType
public interface SocialUtils {
    static final String PN_PARENTID = "social:parentid";
    static final String PN_DATE = "added";
    static final String PN_COMMENT_RESOURCETYPE = "commentresourcetype";
    static final String PN_TOPIC_RESOURCETYPE = "topicresourcetype";
    static final String PN_POST_RESOURCETYPE = "postresourcetype";
    static final String PN_SLING_RESOURCETYPE = SlingConstants.NAMESPACE_PREFIX + ":"
            + SlingConstants.PROPERTY_RESOURCE_TYPE;
    static final String PN_DS_KEY = "social:key";
    static final String PN_CS_ROOT = "social:rootCommentSystem";
    static final String PN_BASETYPE = "social:baseType";
    static final String PN_ATTACHMENT_LIST = "social:attachments";
    static final String PN_IS_REPLY = "social:isReply";
    static final String PN_ENTITY = "social:entity";

    static final String CC_ASIPATH = "asipath";
    static final String CC_HOST_URL = "hosturl";
    static final String CC_REPORT_SUITE = "reportsuite";
    static final String CC_CONSUMER_KEY = "consumerkey";
    static final String CC_SECRET_KEY = "secret";
    static final String COMMENTID_SEPARATOR = "__";

    /**
     * The property name for the path to the comments component.
     */
    static final String PROP_COMPONENT = "commentsNode";

    /**
     * The resource type for the comments component.
     */
    static final String COMMENT_CS_RESOURCE_TYPE = "social/commons/components/comments";

    /**
     * The path to the user-generated content.
     */
    static final String PATH_UGC = "/content/usergenerated";

    /**
     * The SRP prefix.
     */
    static final String ASI_UGC_PREFIX = PATH_UGC + "/asi";

    /**
     * The Cloud prefix.
     */
    final String SRP_CLOUD_PATH = ASI_UGC_PREFIX + "/cloud";

    /**
     * Mongo prefix.
     */
    final String SRP_MONGO_PATH = ASI_UGC_PREFIX + "/mongo";

    /**
     * JSRP prefix.
     */
    final String SRP_JSRP_PATH = ASI_UGC_PREFIX + "/jcr";

    /**
     * Property name for pointing a Social component to remote piece of UGC.
     */
    final String PN_REMOTE_UGC_LOCATION = "remoteUGC";

    /**
     * Property name for bucket resource type.
     */
    static final String BUCKET_TYPE = "sling:Folder";

    /**
     * Property name for group's member group.
     */
    static final String GROUP_MEMBERGROUP = "membergroup";

    /**
     * The comment node type.
     */
    static final String COMMENT_NODE_TYPE = "cq:Comment";

    /**
     * enum for avartar's size.
     */
    enum AVATAR_SIZE {

        /**
         * Avartar's size for 32 and for 48.
         */
        THIRTY_TWO(32), FOURTY_EIGHT(48), EIGHTY(80), THIRTY_FOUR(34);

        /**
         * Avartar's size.
         */
        private final int size;

        /**
         * Set avartar's size for 32 and for 48.
         * @param s The size for avatar
         */
        AVATAR_SIZE(final int s) {
            size = s;
        }

        @Override
        public String toString() {
            return String.valueOf(this.size);
        }
    }

    /**
     * Default avatar URL.
     */
    static final String DEFAULT_AVATAR = "/etc/designs/default/images/social/avatar.png";

    /**
     * The property name for the Comment Attachments folder.
     */
    static final String NN_COMMENT_ATTACHMENTS = "attachments";

    // Taken from CommentBase as it is not exposed as an API. Could be moved to some shared service.
    String createUniqueNameHint(final String message);

    // Taken from CommentBase as it is not exposed as an API. Could be moved to some shared service.
    String createUniqueNameHint(final String message, final int numRandomChars);

    String getResourceTypeFromDesign(final Resource resource, final String styleProperty, final String defaultValue);

    /**
     * Checks a path and an action based on the passed in resolver.
     * @param resolver the resource resolver to use to evaluate the permissions
     * @param path the path to the resource to check
     * @param action the action to check
     * @return True if the resolver is allowed to take the requested action, otherwise false
     */
    Boolean checkPermission(final ResourceResolver resolver, final String path, final String action);

    /**
     * Gets the base UGC Resource from a SocialResource. This is used to get the JCR base node of a remote piece of
     * UGC. It will also create all the parallel content/usergenerated paths.
     * @param userResource a path to a resource that needs to have its UGC Resource located.
     * @return the path to the UGC location for this social resource
     */
    Resource getUGCResource(final Resource userResource);

    @Deprecated
    Resource getUGCResource(final Resource userResource, final ResourceResolverFactory rrf);

    /**
     * Gets the base UGC Resource from a SocialResource. This is used to get the JCR base node of a remote piece of
     * UGC. It will also create all the parallel content/usergenerated paths.
     * @param userResource a path to a resource that needs to have its UGC Resource located.
     * @param resourceTypeHint the resource type to set on the root node in the UGC tree, this is used when components
     *            are cq:included onto a page
     * @return the path to the UGC location for this social resource
     */
    Resource getUGCResource(final Resource userResource, final String resourceTypeHint);

    @Deprecated
    Resource getUGCResource(final Resource userResource, final ResourceResolverFactory rrf,
        final String resourceTypeHint);

    /**
     * Generates a (secure) random string with the given length.
     * @param length length of random string.
     * @return a random string.
     */
    String generateRandomString(final int length);

    /**
     * From a resource get the cloud configuration for the social data service.
     * @param resource the base resource to check the cloud configuration for
     * @return a configuration for the social data store or null if one does not exist
     * @deprecated use getStorageConfig
     */
    @Deprecated
    Configuration getStorageCloudServiceConfig(final Resource resource);

    /**
     * From a resource get the configuration for the social data service.
     * @param resource the base resource to get the configuration for
     * @return a configuration for the social data store or null if one does not exist
     */
    SocialResourceConfiguration getStorageConfig(final Resource resource);

    /**
     * From a resource get the configuration for the social data service.
     * @return a configuration for the social data store or null if one does not exist
     */
    SocialResourceConfiguration getDefaultStorageConfig();

    /**
     * Returns the user properties denoted by the given <code>userId</code>. The user props are looked for using the
     * provided resource resolver, so as to ensure that the user properties are only accessible to users having the
     * necessary access rights on the requested user properties.
     * @param resolver The {@link ResourceResolver}.
     * @param userId The user id for which to retrieve the user properties.
     * @return The {@link UserProperties} or <code>null</code> if not found.
     */
    UserProperties getUserProperties(final ResourceResolver resolver, final String userId);

    /**
     * Returns the userProperties avatar URL or {@link CollabUtil#DEFAULT_AVATAR} if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties);

    /**
     * Returns the userProperties avatar URL or {@link CollabUtil#DEFAULT_AVATAR} if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @param absoluteDefaultAvatar The absolute default avatar
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties, final String absoluteDefaultAvatar);

    /**
     * Returns the userProperties avatar URL or absoluteDefaultAvatar if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @param absoluteDefaultAvatar The absolute default avatar
     * @param size The avatar size (for example, 32)
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties, final String absoluteDefaultAvatar, final AVATAR_SIZE size);

    /**
     * Returns the userProperties avatar URL or {@link CollabUtil#DEFAULT_AVATAR} if profile has no avatar defined.
     * @param userProperties The userProperties (may be null)
     * @param size The avatar size (for example, 32)
     * @return the avatar URL or the default one.
     */
    String getAvatar(final UserProperties userProperties, final int size);

    /**
     * Returns the given <code>resource</code>'s path without its potential <i>/jcr:content/...</i> suffix, thus
     * representing a page path.
     * @param resource The resource to check.
     * @return A <code>String</code> representing the page path.
     */
    String getPagePath(final Resource resource);

    /**
     * Returns the given <code>resource</code>'s path without its potential <i>/jcr:content/...</i> suffix, thus
     * representing a page path.
     * @param path The path to check.
     * @return A <code>String</code> representing the page path.
     */
    String getPagePath(final String path);

    /**
     * Create node.
     * @param resolver The {@link ResourceResolver} to use for persisting values.
     * @param path The path of the node to be created
     * @param nodeType The node type
     * @return Node object.
     * @throws SocialException if error occurs in Social Collaboration
     */
    Node createNode(final ResourceResolver resolver, final String path, final String nodeType) throws SocialException;

    /**
     * This method maps the given <code>resource</code> to its equivalent path in /usergenerated, e.g. as the
     * relationship a page <i>/content/test</i> to its comment at <i>/content/usergenerated/content/test</i>. Note:
     * This method maps the Cloud Storage path to the JCR marker used for ACL checking, not the path that is used as
     * the resource path for the user generated content itself
     * @param resource The resource to transpose to the comment's UCG path.
     * @return A <code>String</code> representing the equivalent UCG path.
     * @deprecated Use resourceToACLPath or resourceToUGCStoragePath
     */
    @Deprecated
    String resourceToUGCPath(final Resource resource);

    /**
     * This method maps the given <code>resource</code> to its equivalent path in UGC for ACL checking. For cloud
     * storage a component like: <i>/content/site/en/page/jcr:content/par/forum</i> will map to
     * <i>/content/usergenerated/content/site/en/page/</i>. For JCR content,
     * <i>/content/site/en/page/jcr:content/par/forum</i> will map to:
     * <i>/content/usergenerated/content/site/en/page/</i> Note: This method maps the Cloud Storage path to the JCR
     * marker used for ACL checking, not the path that is used as the resource path for the user generated content
     * itself
     * @param resource The resource to transpose to the comment's UCG path.
     * @return A <code>String</code> representing the equivalent UCG path.
     */
    String resourceToACLPath(final Resource resource);

    /**
     * This method maps the given <code>resource</code> to its equivalent UGC page path. For cloud storage a component
     * like: <i>/content/site/en/page/jcr:content/par/forum</i> will map to
     * <i>/content/usergenerated/asi/cloud/content/site/en/page/</i>. For JCR content,
     * <i>/content/site/en/page/jcr:content/par/forum</i> will map to:
     * <i>/content/usergenerated/content/site/en/page/</i> Note: A cloud path can not be used for ACL checking. See
     * resourceToACLPath for mapping the resource to a UGC path suitable for ACL checking (returns the 'marker' in
     * /content/usergenerated/content)
     * @param resource The resource to transpose to the cloud UGC path.
     * @return A <code>String</code> representing the equivalent cloud UCG path.
     */
    String resourceToUGCStoragePath(final Resource resource);

    /**
     * Can add node at path.
     * @param session session
     * @param path path
     * @return true if node can be added at path in this session
     */
    boolean canAddNode(final Session session, final String path);

    /**
     * Indicates whether the user within the given resource resolver has enough permissions to post to the given
     * resource component. If no posts to the specified resource have yet been made, the permissions on the
     * {@link #PATH_UGC} path are checked instead.
     * @param resolver The {@link ResourceResolver}
     * @param resource The {@link Resource} component.
     * @return <code>true</code> if the user may post.
     */
    boolean mayPost(final ResourceResolver resolver, final Resource resource);

    /**
     * Prepare user generated content for the specified path. The path can be the page path or the ugc collection
     * root.
     * @param resolver The {@link ResourceResolver} to use for persisting values.
     * @param path The page path
     * @return the user generated content page path.
     * @throws SocialException if error occurs in Social Collaboration
     */
    String prepareUserGeneratedContent(final ResourceResolver resolver, final String path) throws SocialException;

    /**
     * This method maps the given <code>resource</code> in /content/usergenerated to its equivalent path in the normal
     * content tree, e.g. as the relationship of a comment in <i>//content/usergenerated/content/test</i> to its
     * parent resource at <i>/content/test</i>.
     * @param resource The resource to transpose.
     * @return A <code>String</code> representing the equivalent normal content path.
     */
    String UGCToResourcePath(final Resource resource);

    /**
     * This method maps the given <code>resource</code> in /content/usergenerated to its equivalent path in the normal
     * content tree, e.g. as the relationship of a comment in <i>//content/usergenerated/content/test</i> to its
     * parent resource at <i>/content/test</i>.
     * @param ugcPath The path to transpose.
     * @param resolver The resource resolver to use.
     * @return A <code>String</code> representing the equivalent normal content path.
     */
    String UGCToResourcePath(final String ugcPath, final ResourceResolver resolver);

    /**
     * Map a UGC path, avoiding multiple round trips.
     * @param resource The resource to transpose.
     * @return the mapped path
     */
    String mapUGCPath(final Resource resource);

    /**
     * Map a UGC path, avoiding multiple round trips.
     * @param ugcPath the ugc path to map
     * @param resolver the resolver to use
     * @return the mapped path
     */
    String mapUGCPath(final String ugcPath, final ResourceResolver resolver);

    /**
     * Finds the page which contains the given resource.
     * @param resource the resource for which the page is to be found
     * @return the page that contains the resource
     */
    Page getContainingPage(Resource resource);

    /**
     * @param path path to the page
     * @param resolver resolver to us
     * @return the {@link Page} object for the given path if a page exists, null otherwise.
     */
    Page getPage(String path, ResourceResolver resolver);

    /**
     * A simple way of getting the configured SocialResourceProvider for a resource.
     * @param resource The resource to use as the base of the resolution
     * @return The social resource provider
     */
    SocialResourceProvider getConfiguredProvider(final Resource resource);

    /**
     * Gets the social profile url for a user based on the page being passed in. The form used to show the profile
     * will be the read from "cq:socialProfilePage" in the content hierarchy "above" the page requested.
     * @param username user to find the profile for.
     * @param resolver the resolver to use, which must have read access to the profile other
     * @param page the page to use as the basis for the search for "cq:socialProfilePage" property.
     * @return a url to the profile or null if the username was not found.
     */
    String getSocialProfileURL(final String username, final ResourceResolver resolver, final Page page);

    /**
     * Check if the login user can moderate a given resource. This will always return false if the resource is not
     * under the UGC tree.
     * @param resource The resource to check
     * @return true iff the login user can moderate a given resource.
     */
    boolean hasModeratePermissions(final Resource resource);

    /**
     * Returns the resource type of a Component when it is included dynamically via cq:include. This will check the
     * component node, then the design to determine if one is available, if it cannot retrieve another resource type
     * it will return the defaultResourceType.
     * @param component the component to determine the type for
     * @param defaultResourceType the fall back if no suitable matchers are found
     * @param designPropertyName the name of the design property to try and use
     * @return a valid resource type to use when dealing with dynamically included components
     */
    String getResourceTypeForIncludedResource(final Resource component, final String defaultResourceType,
        final String designPropertyName);

    /**
     * May access ugc.
     * @param resolver the resolver
     * @return true, if successful
     */
    boolean mayAccessUGC(final ResourceResolver resolver);

    TranslationManager getTranslationManager();

    /**
     * Get a SocialResourceProvider given a resource.
     * @param resource The resource to return the provider for.
     * @return social resource provider
     */
    SocialResourceProvider getSocialResourceProvider(final Resource resource);

    /**
     * Get a SocialResourceProvider given a path and a resolver. Replaces SocialUtils.getSocialResourceProvider(final
     * String path)
     * @param path The path to return the provider for.
     * @param resolver A resolver with sufficient privileges to fetch a resource within the asi path.
     * @return social resource provider
     */
    SocialResourceProvider getSocialResourceProvider(final ResourceResolver resolver, final String path);

    /**
     * We no longer support this function. It had serious errors because it would close the session of a common
     * service user after performing its task. use SocialUtils.getSocialResourceProvider(ResourceResolver resolver,
     * String path) instead
     */
    @Deprecated
    SocialResourceProvider getSocialResourceProvider(final String path);

    /**
     * Return a resource at path. In SRP, we don't have place keeper parent nodes, so resource may not exist at the
     * path, but one may exist below the path. Create a SyntheticResource of SocialUtils.COMMENT_NODE_TYPE if UGC path
     * and no resource at path.
     * @param resolver Resolver to use
     * @param path The path to get the resource at
     * @return the resource at path (or synthetic if uGC and no resource at path)
     */
    Resource getResourceAtPath(final ResourceResolver resolver, final String path);

    /**
     * Return a resource at path. In SRP, we don't have place keeper parent nodes, so resource may not exist at the
     * path, but one may exist below the path. Create a SyntheticResource of passed in type if UGC path and no
     * resource at path.
     * @param resolver Resolver to use
     * @param path The path to get the resource at
     * @param resourceType Resource type of returned SyntheticResource.
     * @return the resource at path (or synthetic if uGC and no resource at path)
     */
    Resource getResourceAtPath(final ResourceResolver resolver, final String path, final String resourceType);

    /**
     * Check if the login user is the resource owner.
     * @param resource The resource to check
     * @return true iff the login user is the resource owner.
     */
    boolean isResourceOwner(final Resource resource);

    /**
     * Return reference to TranslationSaveQueue to save translation batch jobs.
     */
    TranslationSaveQueue getTranslationSaveQueue();

    /**
     * This method maps the given <code>resource</code> to its equivalent resource path based on applicable global
     * shared storage cloud config settings.
     * @param resource The resource to transpose.
     * @return string representing the global shared storage resource path.
     */
    String getCommonStorePath(final Resource resource);

    /**
     * Checks if is user in group.
     * @param resolver The {@link ResourceResolver} used to get the user information. Should be ServiceUser/Admin user
     *            resolver if not checking for current user
     * @param userId the user id
     * @param groupIds the group ids
     * @return true, if is user in group
     */
    boolean isUserInGroups(final ResourceResolver resolver, final String userId, final List<String> groupIds);
}
