/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * This interface defines the API that will allow visibility / access into the shared translation save queue
 */
public interface TranslationSaveQueue {

    /**
     * @return Queue that clients can modify and update TranslationUpdates
     */
    ConcurrentLinkedQueue<TranslationUpdate> getUpdateQueue();

    /**
     * Saves every element in the queue with the JCR session
     */
    void saveQueue();

    /**
     * Saves up to the number of elements passed from the queue
     * @param numberOfUpdates Number of updates (maximum) to process
     */
    void saveQueue(int numberOfUpdates);

    /**
     * Forces this service to evaluate the queue and determine if the queues contents exceed the batch limits
     */
    void registerUpdate();

}
