/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase;

import java.util.Map;

public class TranslationUpdate {

    private final String resourcePath;
    private final String toLan;
    private final Map<String, String> translation;

    /**
     * Translation Updates are used to feed the TranslationSaveQueue service
     * @param resourcePath Path of the resource that is being updated
     * @param toLan Target language
     * @param translation Translated mappings from TranslationResults
     */
    public TranslationUpdate(final String resourcePath, final String toLan, final Map<String, String> translation) {
        this.resourcePath = resourcePath;
        this.toLan = toLan;
        this.translation = translation;
    }

    /**
     * @return Path of the resource that is being updated
     */
    public String getResourcePath() {
        return resourcePath;
    }

    /**
     * @return Target language
     */
    public String getToLan() {
        return toLan;
    }

    /**
     * @return Translated mappings from TranslationResults
     */
    public Map<String, String> getTranslation() {
        return translation;
    }
}
