/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase.core;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.srp.config.SocialResourceConfiguration;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * This is the basis for all the Social Adapter factories that connected to Social Storage. It provides some simple
 * utilities to those classes that extend from it.
 */
@Component(componentAbstract = true)
public abstract class AbstractSocialAdapterFactory {
    @Reference
    protected SocialUtils socialUtils;

    /**
     * This will taken a particular resource and retrieve the cloud configuration for Social Data Storage.
     * @param resource the resource to find the cloud configuration above
     * @return the remote location configured in cloud services
     */
    // TODO : Can we kill this?
    protected Configuration getCloudConfiguration(final Resource resource) {
        return socialUtils.getStorageCloudServiceConfig(resource);
    }

    /**
     * This will taken a particular resource and retrieve the cloud configuration for Social Data Storage.
     * @param resource the resource to find the cloud configuration above
     * @return the remote location configured in cloud services
     */
    protected SocialResourceConfiguration getStorageConfig(final Resource resource) {
        return socialUtils.getStorageConfig(resource);
    }

}
