/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase.core;

import java.util.Iterator;

import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.srp.config.ASRPConfiguration;
import com.adobe.cq.social.srp.config.SocialResourceConfiguration;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * Implementation of com.day.cq.wcm.webservicesupport.Configuration. Used to provide a Configuration return for
 * deprecated APIs that return it.
 */
public class ConfigurationImpl implements Configuration {

    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);

    private final String asiPath;
    private final String consumerKey;
    private final String secretkey;
    private final String hostUrl;
    private final String reportsuite;

    /**
     * Constructor. Note: this is to allow for deprecated API which returns a
     * com.day.cq.wcm.webservicesupport.Configuration Save the configuration associated with this provider
     * @param socialResourceConfig the SocialResourceConfiguration.
     */
    public ConfigurationImpl(final SocialResourceConfiguration socialResourceConfig) {
        this.asiPath = socialResourceConfig.getAsiPath();
        if (socialResourceConfig instanceof ASRPConfiguration) {
            final ASRPConfiguration asrpConfig = (ASRPConfiguration) socialResourceConfig;
            this.consumerKey = asrpConfig.getConsumerKey();
            this.secretkey = asrpConfig.getSecretKey();
            this.hostUrl = asrpConfig.getHostURL();
            this.reportsuite = asrpConfig.getReportSuite();
        } else {
            this.consumerKey = "consumerkey";
            this.secretkey = "secretkey";
            this.hostUrl = "hosturl";
            this.reportsuite = "mongo";
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getTitle() {
        return "";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getDescription() {
        return "";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getName() {
        return "";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getPath() {
        return "";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Long getLastModified() {
        return 0L;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getIconPath() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getThumbnailPath() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Template getTemplate() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Resource getParent() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Resource getResource() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Resource getContentResource() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public InheritanceValueMap getProperties() {
        return null;
    }

    /**
     * {@inheritDoc} Return the requested configuration information Only String type returned.
     */
    @Override
    @SuppressWarnings("unchecked")
    public <T> T get(final String name, final T defaultValue) {
        LOG.debug("getting {} ", name);
        if (SocialUtils.CC_ASIPATH.equalsIgnoreCase(name)) {
            return (T) this.asiPath;
        } else if (SocialUtils.CC_CONSUMER_KEY.equalsIgnoreCase(name)) {
            return (T) this.consumerKey;
        } else if (SocialUtils.CC_SECRET_KEY.equalsIgnoreCase(name)) {
            return (T) this.secretkey;
        } else if (SocialUtils.CC_HOST_URL.equalsIgnoreCase(name)) {
            return (T) this.hostUrl;
        } else if (SocialUtils.CC_REPORT_SUITE.equalsIgnoreCase(name)) {
            return (T) this.reportsuite;
        }

        return null;

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public <T> T getInherited(final String name, final T defaultValue) {
        return defaultValue;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Iterator<Configuration> listChildren() {
        return null;
    }

}
