/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase.core.attachments;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.request.RequestParameter;

public class FileUploadSizeLimit {
    private final long attachmentSizeLimit;
    private final long imageSizeLimit;
    private static final String[] imagesContentType = new String[]{".png", ".jpg", ".jpeg", ".gif"};

    public FileUploadSizeLimit(final long attachmentSizeLimit, final long imageSizeLimit) {
        this.attachmentSizeLimit = attachmentSizeLimit;
        this.imageSizeLimit = imageSizeLimit;
    }

    public boolean fits(final RequestParameter fileRequestParameter) {
        final FileDataSource attachmentDataSource = new AttachmentDataSource(fileRequestParameter);
        return fits(attachmentDataSource);
    }

    public boolean fits(final FileDataSource attachmentDataSource) {
        final String contentType = attachmentDataSource.getType();
        final long contentSize = attachmentDataSource.getSize();
        if (contentSize < 0) {
            return false;
        }
        if (ArrayUtils.contains(imagesContentType, contentType)) {
            return contentSize <= imageSizeLimit;
        } else {
            return contentSize <= attachmentSizeLimit;
        }
    }
}
