/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.ugcbase.dispatcher.api;

public interface FlushService {

    public enum FlushType {
        IMMEDIATE_FLUSH, DELAYED_FLUSH
    }

    public enum RefetchType {
        NO_REFETCH, IMMEDIATE_REFETCH, DELAYED_REFETCH
    }

    /**
     * Sends a flush request to the 'flush' replication-agent using the given session and using the given refetchType.
     * @param userId the userId on which behalf this url is being flushed - will propagate to the replication agent
     * @param flushType whether to send this flush request directly or to delay it to reduce flush-load on
     *            high-frequency resources
     * @param urlToFlush the file matching this path plus all matching urlToFlush.* will be flushed with the
     *            dispatcher (as a result of using DEACTIVATE).
     * @param refetchType whether to refetch any urls, immediately or delayed
     * @param refetchUrls optional refetch urls
     * @return whether or not the flush command was sent to the agent
     */
    public boolean sendFlushUrl(final String userId, final FlushType flushType, final String urlToFlush,
        final RefetchType refetchType, String... refetchUrls);
}
