/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.ugcbase.moderation;

import java.util.Iterator;
import java.util.List;

import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ProviderType;

/**
 * The interface for the Auto-Moderation service.
 */
@ProviderType
public interface AutoModeration {

    /**
     * Adds a process to the cache.
     * @param process an implementation of {@link AutoModerationProcess}
     */
    void addProcess(AutoModerationProcess process);

    /**
     * Removes a process from the cache.
     * @param process an implementation of{@link AutoModerationProcess}
     */
    void removeProcess(AutoModerationProcess process);

    /**
     * Returns all available automated processes.
     * @return an {@link Iterator} of all bounded and added moderation processes.
     */
    Iterator<AutoModerationProcess> getAllModerationProcesses();

    /**
     * Return the automation sequence.
     * @return an ordered list of moderation process names that will be executed
     */
    List<String> getExecSequence();

    /**
     * Sets an execution sequence.
     * @param sequence the new list of moderation process to execute.
     */
    void setExecSequence(List<String> sequence);

    /**
     * Executes the automation sequence against a user generated content (UGC) resource
     * @param resource the UGC
     */
    void executeSequence(Resource resource);
}
