package com.adobe.cq.targetrecommendations.api.model;

import java.util.Map;

/**
 * Abstraction of a Target Recommendations product feed
 *
 */
public interface ProductFeed extends RecommendationsEntity {
    
    /**
     * Feed type enumeration
     */
    public enum FeedType {
        GOOGLE_PRODUCT,
        CSV,
        SITECATALYST_SAINT;
    };
    
    /**
     * Feed schedule enumeration.
     * Please note that bi_weekly refers to "once every two weeks"
     */
    public enum FeedSchedule {
        DAILY,
        WEEKLY,
        BI_WEEKLY,
        NEVER;
    };
    
    /**
     * Uniquely identifies a {@code ProductFeed}
     * 
     * @return a {@link Integer} value identifying this {@code ProductFeed}
     */
    public int getId();
    
    /**
     * Get the name of this {@code ProductFeed}
     * 
     * @return a {@link String} object containing this product feed's name
     */
    public String getName();
    
    /**
     * This feed's type
     * 
     * @return a {@code FeedType} value
     */
    public FeedType getType();
    
    /**
     * Product update frequency
     * 
     * @return a {@code FeedSchedule} value
     */
    public FeedSchedule getSchedule();
    
    /**
     * Environment id of this feed
     * 
     * @return the environment id
     */
    public int getEnvironmentId();
    
    /**
     * Defines the mapping between the feed's fields and the Target Recommendation's entities.
     * Not all field types support this mapping (e.g. csv)
     * 
     * @return a {@code Map} where keys point to feed field names and values to target recommendations entity names
     */
    public Map<String, String> getAttributeMapping();
    
    /**
     * Defines the connection properties for the feeds requiring remote server connections
     * Not all feed types support connection properties (e.g. SAINT)
     * 
     * @return a {@code Map} containing the connection properties as key-value pairs
     */
    public Map<String, String> getConnectionProperties();
}
