/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.targetrecommendations.api.model;

import java.util.List;

/**
 * Abstracts a Target Recommendation configuration information
 */
public interface RecommendationAlgorithmConfiguration {
    
    /**
     * Target Recommendation Algorithm configuration key (e.g. 'currentCategory')
     * 
     * @return a {@code String} representation of the configuration key
     */
    public String getConfigurationKey();
    
    /**
     * Algorithm type for the selected configuration key.
     * 
     * @return a {@code String} representation of the algorithm type
     */
    public String getConfigurationType();
    
    /**
     * Data source for the selected algorithm.
     * When not specified it is usually considered an MBox data source
     * 
     * @return a {@code String} representation of algorithm data source
     */
    public String getConfigurationDataSource();
    
    /**
     * Extra configuration attribute for the algorithm
     * 
     * @return the {@code String} representing the configuration attribute
     */
    public String getConfigurationAttribute();
    
    /**
     * Interval to be taken into account by the algorithm.
     * 
     * @return a {@code DayCountInterval} enum value containing the time interval
     */
    public DayCountInterval getDayCount();
    
    
    /**
     * Price range minimum value for products to be considered by this algorithm
     * 
     * @return the minimum price range value
     */
    public double getPriceRangeMin();
    
    /**
     * Price range maximum value for products to be considered by this algorithm
     * 
     * @return the maximum price range value
     */
    public double getPriceRangeMax();
    
    /**
     * Product confidence configuration for 'fullDataOptimizing' type algorithms.
     * No effect for other algorithm types.
     * 
     * @return the product confidence configuration string
     */
    public String getProductConfidence();
    
    /**
     * Minimum inventory value for this algorithm
     * Needs to be non-negative to be taken into account.
     * 
     * @return the minimum inventory value
     */
    public int getMinInventory();
    
    /**
     * The inclusion rules for this algorithm.
     * 
     * @return a {@code List} containing {@code RecommendationAlgorithmInclusionRule} inclusion rules
     */
    public List<RecommendationAlgorithmInclusionRule> getInclusionRules();
}
