/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.targetrecommendations.api.model;

import java.util.List;

/**
 * Abstract an inclusion rule for a Target Recommendation algorithm
 */
public interface RecommendationAlgorithmInclusionRule {
    
    /**
     * Product attribute to be used by this inclusion rule
     * 
     * @return {@code String} containing the product attribute
     */
    public String getAttribute();
    
    /**
     * The matching operation to be applied on the product attribute
     * 
     * @return {@code String} representation of the inclusion rule operation to be applied
     */
    public String getOperation();
    
    /**
     * List of values to be checked by this inclusion rule
     * 
     * @return a {@code List}
     */
    public List<String> getValues();
    
    /**
     * The minimum boundary used by the 'dynamicallyRanges' operation.
     * Not used for other operations
     * 
     * @return an integer containing the lower boundary
     */
    public int getLowRange();
    
    /**
     * The maximum boundary used by the 'dynamicallyRanges' operation.
     * Not used for other operations
     * 
     * @return an integer containing the high boundary. Must be &gt; than low range.
     */
    public int getHighRange();
}
