package com.adobe.cq.targetrecommendations.api.model;

import java.util.List;

/**
 * Abstraction of an Adobe Target recommendation
 */
public interface TargetRecommendation extends RecommendationsEntity {
    
    /**
     * Enumeration of the possible states of a Target Recommendations
     */
    public enum RecommendationState {
        ACTIVE,INACTIVE;
    };
    
    /**
     * Uniquely identifies a {@code TargetRecommendation}
     * 
     * @return a {@link Integer} value identifying this {@code TargetRecommendation}
     */
    public int getId();
    
    
    /**
     * Get the name of this {@code TargetRecommendation}
     * 
     * @return a {@link String} object containing this recommendation's name
     */
    public String getName();
    
    /**
     * Get the Id of the product catalog used by this recommendation
     * 
     * @return a {link Integer} value identifying a product catalog
     */
    public int getCatalogId();
    
    /**
     * Get the list of template names used by this recommendation
     * 
     * @return a {@link List} containing the template names
     */
    public List<String> getTemplateNames();
    
    /**
     * Get the state of this recommendation
     * 
     * @return a {@code RecommendationState} enum value with the state of this recommendation
     */
    public RecommendationState getState();
    
    /**
     * Get the list of algorithms used by this recommendation
     * 
     * @return a {@link List} containing the ids of the used algorithms
     */
    public List<Integer> getAlgorithmIds();
    
    /**
     * Gets the name of the MBox where this recommendation is targeted
     * 
     * @return a {@link String} object containing the MBox name
     */
    public String getLocationDisplayMbox();
    
    /**
     * The default content id for this recommendations
     * 
     * @return a non-negative id indicating the default content
     */
    public int getDefaultContentId();
    
    /**
     * Gets the start date of this recommendation
     * 
     * @return {@code String} containing the recommendation campaign start date
     */
    public String getStartDate();

    /**
     * Gets the end date of this recommendation
     * 
     * @return {@code String} containing the recommendation campaign end date
     */
    public String getEndDate();
}
