/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.upgrades.backup;

import java.util.Set;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

/** Backup config service, provides either default values or
 *  values defined under {@link BackupConstants#CONFIG_ROOT_PATH}
 */
public interface BackupConfig {
    /** Must be called before the other methods, reads the config
     *  from CONFIG_ROOT_PATH or defines a default config.
     */
    public void readConfig(Session s) throws RepositoryException;
    
    /** Set of paths to backup before upgrading */
    public Set<String> getPathsToBackup();
    
    /** Set of paths to overwrite when merging content back */
    public Set<String> getPathsToOverwrite();
}
