/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.upgrades.backup;

/** Backup-related constants */
public class BackupConstants {
    /** Root path of pre-upgrade backups */
    public static final String BACKUP_ROOT_PATH = "/var/upgrade/PreUpgradeBackup";
    
    /** Root path of pre-upgrade backups configuration */
    public static final String CONFIG_ROOT_PATH = BACKUP_ROOT_PATH + "/configuration";
    
    /** Folder name for content that must be processed (merged) */
    public static final String TO_PROCESS_FOLDER = "to-process";
    
    /** Folder name for leftover nodes after merge */
    public static final String LEFTOVERS_FOLDER = "leftovers";
    
    /** Folder name used to save content that has been overwritten */
    public static final String OVERWRITTEN_FOLDER = "overwritten";
    
    /** Path to the property the forces the backup to be executed,
     *  regardless of the StartupMode (install, upgrade etc) */
    public static final String FORCE_BACKUP_PROPERTY_PATH = "/var/upgrade/status/preUpgradeBackup.force";
    
    /** The default merge strategy, that's the only one we know, nodes with
     *  a different strategy are ignored. */
    public static final String DEFAULT_MERGE_STRATEGY = "default";
    
    /** Name of the Property that defines the paths to overwrite */
    public static final String OVERWRITE_PATHS_PROPERTY = "overwritePaths";
    
    /** Name of the Property that defines the default config that should not be appliesd */
    public static final String IGNORE_DFAULTCONFIG_PROPERTY = "ignoreDefaultConfig";
    
}
